package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LayerControlPanel extends JPanel {
	
	
	private RoomEditorPanel parent;
	
	private CustomImageDataII openEyeButton;
	private CustomImageDataII shutEyeButton;
	private CustomImageDataII pencilButton;
	
	
	private CustomImageDataII backgroundButton;
	private CustomImageDataII foregroundButton;
	private CustomImageDataII staticBlockButton;
	private CustomImageDataII doorButton;
	private CustomImageDataII commentaryButton;
	private CustomImageDataII enemyButton;
	private CustomImageDataII foreWidgetButton;
	private CustomImageDataII dumpImageButton;
	
	
	
	public static final int BLOCK_LAYER = 0;
	public static final int DOOR_LAYER = 1;
	public static final int COMMENTARY_LAYER = 2;
	public static final int ENEMY_LAYER = 3;
	public static final int WIDGET_LAYER = 4;
	
	
	
	private int currentLayer;
	
	private boolean backgroundVisible;
	private boolean foregroundVisible = true;
	private boolean staticBlockVisible = true;
	private boolean doorVisible;
	private boolean commentaryVisible;
	private boolean enemyVisible;
	private boolean foreWidgetVisible;
	
	private IntRect backgroundEyeClickRect = new IntRect(139, 19, 33,22);
	private IntRect foregroundEyeClickRect = new IntRect(139, 99, 33,22);
	private IntRect staticBlockEyeClickRect = new IntRect(139, 179, 33,22);
	private IntRect doorEyeClickRect = new IntRect(139, 259, 33,22);
	private IntRect commentaryEyeClickRect = new IntRect(139, 299, 33,22);
	private IntRect enemyEyeClickRect = new IntRect(139, 339, 33,22);
	private IntRect forewidgetEyeClickRect = new IntRect(139, 419, 33,22);
	
	private IntRect backgroundForegroundLayerClickRect = new IntRect(11, 15, 118, 30 + 80);
	private IntRect staticBlockLayerClickRect = new IntRect(11, 174, 118, 30 );
	private IntRect doorLayerClickRect = new IntRect(11, 254, 118, 30 );
	private IntRect commentaryLayerClickRect = new IntRect(11, 294, 118, 30 );
	private IntRect enemyLayerClickRect = new IntRect(11, 334, 118, 30 );
	private IntRect forewidgetLayerClickRect = new IntRect(11, 414, 118, 30 );
	private IntRect exportViewClickRect = new IntRect(11, 454, 118,30);
	
	
	public LayerControlPanel(RoomEditorPanel thePanel) {
		super();
		
		parent = thePanel;
		
		openEyeButton = new CustomImageDataII("/images/THE_OPEN_EYE.GIF", Color.WHITE, this);
		shutEyeButton = new CustomImageDataII("/images/THE_SHUT_EYE.GIF", Color.WHITE, this);
		pencilButton = new CustomImageDataII("/images/pencil.GIF", Color.WHITE, this);
		
		
		backgroundButton = new CustomImageDataII("/images/bgLayer.GIF", Color.YELLOW, this);
		foregroundButton = new CustomImageDataII("/images/foregroundLayer.GIF", Color.RED, this);
		staticBlockButton = new CustomImageDataII("/images/blockLayer.GIF", Color.WHITE, this);
		doorButton = new CustomImageDataII("/images/doorLayer.GIF", Color.WHITE, this);
		commentaryButton = new CustomImageDataII("/images/commentLayer.GIF", Color.WHITE, this);
		enemyButton = new CustomImageDataII("/images/enemyLayer.GIF", Color.WHITE, this);
		foreWidgetButton = new CustomImageDataII("/images/frontLayer.GIF", Color.WHITE, this);
		dumpImageButton = new CustomImageDataII("/images/exportView2.GIF", Color.white, this);
		
		
		this.setPreferredSize(new Dimension(175, 400));
		this.setMinimumSize(new Dimension(175, 400));
		this.setMaximumSize(new Dimension(175, 400));
		
		this.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				clickHappened(e);
			}
		});
		
	}
	
	
	public void clickHappened(MouseEvent e) {
		
//		System.out.println("click happened at " + e.getX() + ", " + e.getY());
		
		parent.unselectEverything();
		
		Point p = new Point(e.getX(), e.getY());
		
		if(foregroundEyeClickRect.contains(p)) {
			foregroundVisible = !foregroundVisible;
			
//			System.out.println("click was in the foreground eye rect!  foregroundVisible is now: " + foregroundVisible);
			
			parent.getEditorCanvas().determineCenterOfViewport();
		}
		if(backgroundEyeClickRect.contains(p)) {
			backgroundVisible = !backgroundVisible;
			
			
		}
		if(backgroundForegroundLayerClickRect.contains(p)) {
			parent.getEditorCanvas().reOpenNewRoomWizardForEdit();
		}
		
		
		if(staticBlockEyeClickRect.contains(p) && currentLayer != BLOCK_LAYER) {
			staticBlockVisible = !staticBlockVisible;
			
		}
		if(staticBlockLayerClickRect.contains(p)) {
			staticBlockVisible = true;
			if(currentLayer != BLOCK_LAYER) {
				currentLayer = BLOCK_LAYER;
				parent.getEditorPalette().unselectEverything();
				parent.getEditorCanvas().useDefaultCursor();
			}
			
			parent.getEditorPalette().readjustWidthAndHeight();
			
		}
		
		
		if(doorEyeClickRect.contains(p) && currentLayer != DOOR_LAYER) {
			doorVisible = !doorVisible;
			
		}
		if(doorLayerClickRect.contains(p)) {
			doorVisible = true;
			if(currentLayer != DOOR_LAYER) {
				currentLayer = DOOR_LAYER;
				parent.getEditorPalette().unselectEverything();
				parent.getEditorCanvas().useDefaultCursor();
			}
			
			parent.getEditorPalette().readjustWidthAndHeight();
			
		}
		
		
		if(commentaryEyeClickRect.contains(p) && currentLayer != COMMENTARY_LAYER) {
			commentaryVisible = !commentaryVisible;
		}
		if(commentaryLayerClickRect.contains(p)) {
			commentaryVisible = true;
			if(currentLayer != COMMENTARY_LAYER) {
				currentLayer = COMMENTARY_LAYER;
				parent.getEditorPalette().unselectEverything();
				parent.getEditorCanvas().useDefaultCursor();
			}
			
			parent.getEditorPalette().readjustWidthAndHeight();
		}
		
		
		
		if(enemyEyeClickRect.contains(p) && currentLayer != ENEMY_LAYER) {
			enemyVisible = !enemyVisible;
			
		}
		if(enemyLayerClickRect.contains(p)) {
			enemyVisible = true;
			if(currentLayer != ENEMY_LAYER){
				currentLayer = ENEMY_LAYER;
				parent.getEditorPalette().unselectEverything();
				parent.getEditorCanvas().useDefaultCursor();
			}
			
			parent.getEditorPalette().readjustWidthAndHeight();
			
		}
		
		
		if(forewidgetEyeClickRect.contains(p) && currentLayer != WIDGET_LAYER) {
			foreWidgetVisible = !foreWidgetVisible;
			
		}
		if(forewidgetLayerClickRect.contains(p)) {
			foreWidgetVisible = true;
			if(currentLayer != WIDGET_LAYER){
				currentLayer = WIDGET_LAYER;
				parent.getEditorPalette().unselectEverything();
				parent.getEditorCanvas().useDefaultCursor();
			}
			
			parent.getEditorPalette().readjustWidthAndHeight();
			
		}
		
		if(exportViewClickRect.contains(p)) {
			
			ExportImportDialog eid = new ExportImportDialog(parent.getFrame());
			
			eid.setModal(true);
			eid.setPreferredSize(new Dimension(300, 400));
			eid.setMaximumSize(new Dimension(300, 400));
			eid.setMinimumSize(new Dimension(300, 400));
			eid.setVisible(true);
			
			int selection = eid.getSelection();
			
			eid.dispose();
			
			if(selection == ExportImportDialog.EXPORT_IMAGE) {
				parent.getEditorCanvas().writeOutViewToImageFile();
			} else if(selection == ExportImportDialog.EXPORT_PALETTE) {
				
				JDialog exportDialog = new JDialog(parent.getFrame());
				ExportPaletteObjectPanel exportPanel = new ExportPaletteObjectPanel(parent, exportDialog); 
				exportDialog.setContentPane(exportPanel);
				exportDialog.setPreferredSize(new Dimension(700, 600));
				exportDialog.setMaximumSize(new Dimension(700, 600));
				exportDialog.setMinimumSize(new Dimension(700, 600));
				exportDialog.setModal(true);
				
				for(PaletteObject po : parent.getEditorPalette().getStaticBlockPaletteObjects()) {
					exportPanel.getStaticPanel().addExportable(po);
				}
				for(PaletteObject po : parent.getEditorPalette().getDoorPaletteObjects()) {
					exportPanel.getDoorPanel().addExportable(po);
				}
				for(PaletteObject po : parent.getEditorPalette().getCommentaryPaletteObjects()) {
					exportPanel.getCommentPanel().addExportable(po);
				}
				for(PaletteObject po : parent.getEditorPalette().getEnemyPaletteObjects()) {
					exportPanel.getEnemyPanel().addExportable(po);
				}
				for(PaletteObject po : parent.getEditorPalette().getWidgetPaletteObjects()) {
					exportPanel.getWidgetPanel().addExportable(po);
				}
				
				
				exportDialog.setVisible(true);
				
				exportDialog.dispose();
			} else if(selection == ExportImportDialog.IMPORT_PALETTE) {
				
				FileDialog fd = new FileDialog(parent.getFrame());
				fd.setModal(true);
				fd.setMode(FileDialog.LOAD);
				fd.setVisible(true);
				
				if(fd.getFile() == null || fd.getDirectory() == null)
					return;
				
				try {
					BufferedReader in = new BufferedReader(new FileReader(fd.getDirectory() + fd.getFile()));
					
					parent.getEditorPalette().loadPaletteObjects(in);
					
					in.close();
				} catch(Exception ee) {
//					ee.printStackTrace();
					JOptionPane.showMessageDialog(this, "Error while importing palette objects!","Error occurred", JOptionPane.WARNING_MESSAGE);
				}
				
				fd.dispose();
			}
			
			
			
		}
		
		
		parent.repaint();
		
	}
	
	
	public void paintComponent(Graphics g) {
		
		super.paintComponent(g);
		
		Color origCol = g.getColor();
		
		
		backgroundButton.drawObject(g, 70, 30);
		if(backgroundVisible) {
			openEyeButton.drawObject(g, 155, 30);
		} else {
			shutEyeButton.drawObject(g, 155, 30);
		}
		
		foregroundButton.drawObject(g, 70, 110);
		if(foregroundVisible) {
			openEyeButton.drawObject(g, 155, 110);
		} else {
			shutEyeButton.drawObject(g, 155, 110);
		}
		
		staticBlockButton.drawObject(g, 70, 190);
		if(currentLayer == BLOCK_LAYER) {
			pencilButton.drawObject(g, 155, 190);
		} else if(staticBlockVisible) {
			openEyeButton.drawObject(g, 155, 190);
		} else {
			shutEyeButton.drawObject(g, 155, 190);
		}
		
		
		doorButton.drawObject(g, 70, 270);
		if(currentLayer == DOOR_LAYER) {
			pencilButton.drawObject(g, 155, 270);
		} else if(doorVisible) {
			openEyeButton.drawObject(g, 155, 270);
		} else {
			shutEyeButton.drawObject(g, 155, 270);
		}
		
		commentaryButton.drawObject(g, 70, 310);
		if(currentLayer == COMMENTARY_LAYER) {
			pencilButton.drawObject(g, 155, 310);
		} else if(commentaryVisible) {
			openEyeButton.drawObject(g, 155, 310);
		} else {
			shutEyeButton.drawObject(g, 155, 310);
		}
		
		
		enemyButton.drawObject(g, 70, 350);
		if(currentLayer == ENEMY_LAYER) {
			pencilButton.drawObject(g, 155, 350);
		} else if(enemyVisible) {
			openEyeButton.drawObject(g, 155, 350);
		} else {
			shutEyeButton.drawObject(g, 155, 350);
		}
		
		
		foreWidgetButton.drawObject(g, 70, 430);
		if(currentLayer == WIDGET_LAYER) {
			pencilButton.drawObject(g, 155, 430);
		} else if(foreWidgetVisible) {
			openEyeButton.drawObject(g, 155, 430);
		} else {
			shutEyeButton.drawObject(g, 155, 430);
		}
		
		dumpImageButton.drawObject(g, 70, 470);
		
		

//		g.setColor(new Color(255, 128, 0));
//		g.drawRect(forewidgetEyeClickRect.getMinX(), forewidgetEyeClickRect.getMinY(), forewidgetEyeClickRect.width(), forewidgetEyeClickRect.height());
		
		
		g.setColor(origCol);
		
		
	}
	
	
	
	public boolean shouldShowBackground() {
		return backgroundVisible;
	}
	
	public boolean shouldShowForeground() {
		return foregroundVisible;
	}
	
	public boolean shouldShowStaticBlocks() {
		return staticBlockVisible;
	}
	
	public boolean shouldShowWidgetsDoorsAndItems() {
		return doorVisible;
	}
	
	public boolean shouldShowCommentaryOnlyObjects() {
		return commentaryVisible;
	}
	
	public boolean shouldShowEnemiesAndMovingBlocks() {
		return enemyVisible;
	}
	
	public boolean shouldShowForegroundWidgets() {
		return foreWidgetVisible;
	}
	
	public int getCurrentLayer() {
		return currentLayer;
	}
	
	public void switchToDoorLayer() {
		doorVisible = true;
		if(currentLayer != DOOR_LAYER) {
			currentLayer = DOOR_LAYER;
			parent.getEditorPalette().unselectEverything();
		}
		this.repaint();
	}
	
	public void switchToCommentaryLayer() {
		commentaryVisible = true;
		if(currentLayer != COMMENTARY_LAYER) {
			currentLayer = COMMENTARY_LAYER;
			parent.getEditorPalette().unselectEverything();
		}
		this.repaint();
	}
}
